package aln.SpawnCommands;

import java.util.Arrays;
import java.util.List;

import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;

public class CommandHome implements ICommand {

  @Override
  public int compareTo(Object arg0) {
    return 0;
  }

  @Override
  public String getCommandName() {
    //return "home";
    return Do.getConfigArrayValue(SpawnCommands.commandNames ,"home");
  }

  @Override
  public String getCommandUsage(ICommandSender icommandsender) {
    return "/"+Do.getConfigArrayValue(SpawnCommands.commandNames ,"home")+"   or   /"+Do.getConfigArrayValue(SpawnCommands.commandNames ,"home")+" mybasename   -   Takes you to your bed/home or the named location.";
  }

  @Override
  public List getCommandAliases() {
    return Arrays.asList(new String[] { });
  }
  
  @Override
  public void processCommand(ICommandSender icommandsender, String[] params) {
    if(icommandsender instanceof EntityPlayer) {
      EntityPlayer player = (EntityPlayer) icommandsender;
      if ( player.worldObj.isRemote ) { return; }
      
      SpawnCommands.loadCommandPermissionsConfig();
      SpawnCommands.loadMiscConfig();
      
      // command permissions. "no" is handled by not registering the command at all. "op" and "enable" are handled here. "all" is the default.
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "home").equalsIgnoreCase("op") && (! Do.IsOp(player)) ) 
      { Do.Say(player,"Op only command.  You are not an op."); return; }
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "home").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ) 
      { Do.Say(player,"Advanced spawn commands are not enabled."); return; }
      
      if (params.length == 0) { 
        if ( Do.getConfigArrayValueBoolean(SpawnCommands.miscConfigArray,"HomeWithNamedLocations") ) 
        { SpawnCommands.listNamedLocations(player); return; }
        else
        { SpawnCommands.GoToBedSpawnPoint(player); return; } 
      }
      
      // params.length == 1
      
      if ( ! Do.getConfigArrayValueBoolean(SpawnCommands.miscConfigArray,"HomeWithNamedLocations") )
      { Do.Say(player,"Using /"+Do.getConfigArrayValue(SpawnCommands.commandNames ,"home")+" and /"+Do.getConfigArrayValue(SpawnCommands.commandNames ,"sethome")+" with named locations is not enabled in the misc config file."); return; }
      
      SpawnCommands.commandSpawn(player, params);
      
    } // end if is player
  }

  @Override
  public boolean canCommandSenderUseCommand(ICommandSender icommandsender) {
    return true;
  }

  @Override
  //public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) { // mc1.8
  public List addTabCompletionOptions(ICommandSender icommandsender, String[] astring) { // mc1.7.10
    return null;
  }

  @Override
  public boolean isUsernameIndex(String[] astring, int i) {
    return false;
  }

}
